/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.EventListenerHelper;
import com.mineswarm.MSTeam;
import com.mineswarm.MineswarmTeams;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class TeamBoards {
    public Plugin plugin = null;
    EventListenerHelper helper;
    MineswarmTeams teams;
    private HashMap<String, Scoreboard> boards = new HashMap();

    public TeamBoards(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setTeamData(EventListenerHelper helper, MineswarmTeams teams) {
        this.helper = helper;
        this.teams = teams;
    }

    public void createScoreBoard(String teamName) {
        try {
            Scoreboard board = Bukkit.getScoreboardManager().getNewScoreboard();
            Objective teamMembersBoard = board.registerNewObjective("teamhp", "dummy", "hp");
            teamMembersBoard.setDisplaySlot(DisplaySlot.SIDEBAR);
            teamMembersBoard.setDisplayName("  Team Health  ");
            this.boards.put(teamName, board);
        }
        catch (Exception er) {
            this.plugin.getLogger().info("Error in making board.  " + er.toString());
        }
    }

    public void updateScoreBoard(List<Player> players, String teamName, Player updatedPlayer) {
        try {
            Scoreboard teamBoard = this.boards.get(teamName);
            Objective teamMembersBoard = teamBoard.getObjective("teamhp");
            try {
                if (updatedPlayer.isOnline()) {
                    updatedPlayer.setScoreboard(teamBoard);
                    if (this.helper.isPlayerDown(updatedPlayer)) {
                        teamMembersBoard.getScore(updatedPlayer.getName()).setScore((int)(updatedPlayer.getHealth() / 2.0 * -1.0));
                    } else {
                        teamMembersBoard.getScore(updatedPlayer.getName()).setScore((int)(updatedPlayer.getHealth() / 2.0));
                    }
                }
            }
            catch (NullPointerException npe) {
                this.plugin.getLogger().warning("Null value present in setScoreboard function (1a). " + npe.toString());
            }
            catch (IllegalArgumentException iae) {
                this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (1a). " + iae.toString());
            }
            catch (IllegalStateException ise) {
                this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (1a). " + ise.toString());
            }
            for (Player p : players) {
                try {
                    if (p == null || !p.isOnline() || p == updatedPlayer) continue;
                    p.setScoreboard(teamBoard);
                    if (this.helper.isPlayerDown(p)) {
                        teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0 * -1.0));
                        continue;
                    }
                    teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0));
                }
                catch (NullPointerException npe) {
                    this.plugin.getLogger().warning("Null value present in setScoreboard function (2a). " + npe.toString());
                }
                catch (IllegalArgumentException iae) {
                    this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (2a). " + iae.toString());
                }
                catch (IllegalStateException ise) {
                    this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (2a). " + ise.toString());
                }
            }
        }
        catch (NullPointerException npe) {
            this.plugin.getLogger().warning("Null value present in setScoreboard function (3a). " + npe.toString());
        }
        catch (IllegalArgumentException iae) {
            this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (3a). " + iae.toString());
        }
        catch (IllegalStateException ise) {
            this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (3a). " + ise.toString());
        }
    }

    public void updateScoreBoard(List<Player> players, String teamName) {
        try {
            this.plugin.getLogger().info("trying for team name: " + teamName);
            Scoreboard teamBoard = this.boards.get(teamName);
            Objective teamMembersBoard = teamBoard.getObjective("teamhp");
            for (Player p : players) {
                try {
                    if (p == null || !p.isOnline()) continue;
                    p.setScoreboard(teamBoard);
                    if (this.helper.isPlayerDown(p)) {
                        teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0 * -1.0));
                        continue;
                    }
                    teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0));
                }
                catch (NullPointerException npe) {
                    this.plugin.getLogger().warning("Null value present in setScoreboard function (2d). " + npe.toString());
                }
                catch (IllegalArgumentException iae) {
                    this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (2d). " + iae.toString());
                }
                catch (IllegalStateException ise) {
                    this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (2d). " + ise.toString());
                }
            }
        }
        catch (NullPointerException npe) {
            this.plugin.getLogger().warning("Null value present in setScoreboard function (3d). " + npe.toString());
        }
        catch (IllegalArgumentException iae) {
            this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (3d). " + iae.toString());
        }
        catch (IllegalStateException ise) {
            this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (3d). " + ise.toString());
        }
    }

    public void setScoreboard(List<Player> players, String teamName, Player updatedPlayer, int health) {
        try {
            Scoreboard teamBoard = this.boards.get(teamName);
            Objective teamMembersBoard = teamBoard.getObjective("teamhp");
            try {
                if (updatedPlayer.isOnline()) {
                    updatedPlayer.setScoreboard(teamBoard);
                    if (this.helper.isPlayerDown(updatedPlayer)) {
                        teamMembersBoard.getScore(updatedPlayer.getName()).setScore(health / 2 * -1);
                    } else {
                        teamMembersBoard.getScore(updatedPlayer.getName()).setScore(health / 2);
                    }
                }
            }
            catch (NullPointerException npe) {
                this.plugin.getLogger().warning("Null value present in setScoreboard function (1). " + npe.toString());
            }
            catch (IllegalArgumentException iae) {
                this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (1). " + iae.toString());
            }
            catch (IllegalStateException ise) {
                this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (1). " + ise.toString());
            }
            for (Player p : players) {
                try {
                    if (p == null || !p.isOnline()) continue;
                    p.setScoreboard(teamBoard);
                    if (p.equals(updatedPlayer)) continue;
                    if (this.helper.isPlayerDown(p)) {
                        teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0 * -1.0));
                        continue;
                    }
                    teamMembersBoard.getScore(p.getName()).setScore((int)(p.getHealth() / 2.0));
                }
                catch (NullPointerException npe) {
                    this.plugin.getLogger().warning("Null value present in setScoreboard function (2). " + npe.toString());
                }
                catch (IllegalArgumentException iae) {
                    this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (2). " + iae.toString());
                }
                catch (IllegalStateException ise) {
                    this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (2). " + ise.toString());
                }
            }
        }
        catch (NullPointerException npe) {
            this.plugin.getLogger().warning("Null value present in setScoreboard function (3). " + npe.toString());
        }
        catch (IllegalArgumentException iae) {
            this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (3). " + iae.toString());
        }
        catch (IllegalStateException ise) {
            this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (3). " + ise.toString());
        }
    }

    public void removeScoreboard(Player player, MSTeam team) {
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
        this.createScoreBoard(team.getName());
        this.updateScoreBoard(team.getMembersPlayerObjects(), team.getName());
    }
}

