/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.MakePotion;
import com.mineswarm.PotionObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ScheduledMobs
implements Listener {
    public Plugin plugin;
    public Database db = null;
    private boolean debugging = false;
    private PotionObjects po = null;
    public HashMap<Location, List<LivingEntity>> spawners = new HashMap();

    public ScheduledMobs(Plugin instance, PotionObjects po) {
        this.plugin = instance;
        this.debugging = this.plugin.getConfig().getBoolean("debugging");
        this.db = new Database(this.plugin);
        this.po = po;
    }

    public void startMobs() {
        for (World world : this.plugin.getServer().getWorlds()) {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "killall all " + world.getName());
        }
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "time " + this.plugin.getConfig().getString("set-time"));
        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "gamerule advance_time " + this.plugin.getConfig().getBoolean("stop-time"));
        this.mobSpawns();
    }

    public void mobSpawns() {
        Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                List<String> data = ScheduledMobs.this.db.getMobSpawners();
                if (data == null) {
                    ScheduledMobs.this.plugin.getLogger().info("No mob spawner data found");
                    return;
                }
                int d = 0;
                while (d < data.size() - 8) {
                    block44: {
                        List<Object> entities;
                        ArrayList<Integer> effects;
                        List<Object> enchantments;
                        int dura;
                        String weapon;
                        int chance;
                        int maxEntities;
                        String entityType;
                        Location location;
                        String world;
                        block45: {
                            List<String> loc = null;
                            world = "";
                            location = null;
                            entityType = "";
                            maxEntities = 0;
                            chance = 0;
                            weapon = "";
                            dura = 0;
                            enchantments = new ArrayList();
                            effects = new ArrayList<Integer>();
                            entities = new ArrayList();
                            try {
                                loc = Arrays.asList(data.get(d).split("\\s*,\\s*"));
                                world = data.get(d + 1);
                                location = new Location(Bukkit.getWorld((String)world), (double)Integer.valueOf(loc.get(0)).intValue(), (double)Integer.valueOf(loc.get(1)).intValue(), (double)Integer.valueOf(loc.get(2)).intValue());
                                if (!Bukkit.getWorld((String)world).getChunkAt(location).isLoaded()) {
                                    ScheduledMobs.this.plugin.getLogger().info("World chunk not loaded, skipping mobs");
                                    break block44;
                                }
                                entityType = data.get(d + 2);
                                maxEntities = Integer.valueOf(data.get(d + 3));
                                chance = Integer.valueOf(data.get(d + 4));
                                weapon = data.get(d + 5);
                                dura = Short.valueOf(data.get(d + 6)).shortValue();
                                if (data.get(d + 7) != "NONE" && data.get(d + 7) != null) {
                                    enchantments = Arrays.asList(data.get(d + 7).split("\\s*,\\s*"));
                                }
                                if (data.get(d + 8) == "NONE" || data.get(d + 8) == null) break block45;
                                try {
                                    String[] stringArray = data.get(d + 8).split("\\s*,\\s*");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String field = stringArray[n2];
                                        if (field != "NONE") {
                                            effects.add(Integer.parseInt(field));
                                        }
                                        ++n2;
                                    }
                                }
                                catch (NumberFormatException field) {}
                            }
                            catch (NullPointerException np) {
                                ScheduledMobs.this.plugin.getLogger().info("Nullpointer in database info for mob spawners " + np.toString());
                            }
                        }
                        try {
                            entities = ScheduledMobs.this.spawners.get(location);
                            if (entities == null) {
                                entities = new ArrayList();
                            }
                        }
                        catch (NullPointerException np) {}
                        while (entities.size() > maxEntities) {
                            entities.remove(entities.size() - 1);
                            if (!ScheduledMobs.this.debugging) continue;
                            ScheduledMobs.this.plugin.getLogger().info("Entities are too many, removing...");
                        }
                        int i = 0;
                        while (i < entities.size()) {
                            Wolf doggo;
                            LivingEntity entity = (LivingEntity)entities.get(i);
                            if (entity.isDead()) {
                                if (chance != 0) {
                                    Random rand = new Random();
                                    if (rand.nextInt(chance) + 1 == 1 && weapon != "NONE") {
                                        String[] en;
                                        ItemStack item = new ItemStack(Material.matchMaterial((String)weapon), 1);
                                        ItemMeta meta = item.getItemMeta();
                                        if (meta instanceof Damageable) {
                                            ((Damageable)meta).setDamage(dura);
                                        }
                                        if (!enchantments.isEmpty() && enchantments.size() > 0 && !enchantments.contains("NONE")) {
                                            for (String enchantment : enchantments) {
                                                en = enchantment.split(":");
                                                try {
                                                    item.addEnchantment(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)en[0].toLowerCase())), Integer.valueOf(en[1]).intValue());
                                                }
                                                catch (Exception whoops) {
                                                    ScheduledMobs.this.plugin.getLogger().warning("Could not enchant weapon, likely a legacy database or blank field where NONE should be.");
                                                }
                                            }
                                        }
                                        mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                        mob.getEquipment().setItemInMainHand(item);
                                        if (!effects.isEmpty()) {
                                            en = effects.iterator();
                                            while (en.hasNext()) {
                                                int pid = (Integer)en.next();
                                                MakePotion poData = ScheduledMobs.this.po.getDrinkableDataById(pid);
                                                for (PotionEffectType effect : poData.effectTypes) {
                                                    mob.addPotionEffect(new PotionEffect(effect, Integer.MAX_VALUE, poData.amplifier, true));
                                                }
                                            }
                                        }
                                        entities.set(i, mob);
                                    } else {
                                        LivingEntity mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                        if (!effects.isEmpty()) {
                                            mob = effects.iterator();
                                            while (mob.hasNext()) {
                                                int pid = (Integer)mob.next();
                                                poData = ScheduledMobs.this.po.getDrinkableDataById(pid);
                                                for (PotionEffectType effect : poData.effectTypes) {
                                                    mob.addPotionEffect(new PotionEffect(effect, Integer.MAX_VALUE, poData.amplifier, true));
                                                }
                                            }
                                        }
                                        entities.set(i, mob);
                                    }
                                } else {
                                    LivingEntity mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                    if (!effects.isEmpty()) {
                                        Iterator pid = effects.iterator();
                                        while (pid.hasNext()) {
                                            PotionEffectType effect;
                                            int pid2 = (Integer)pid.next();
                                            MakePotion poData = ScheduledMobs.this.po.getDrinkableDataById(pid2);
                                            effect = poData.effectTypes.iterator();
                                            while (effect.hasNext()) {
                                                PotionEffectType effect2 = effect.next();
                                                mob.addPotionEffect(new PotionEffect(effect2, Integer.MAX_VALUE, poData.amplifier, true));
                                            }
                                        }
                                    }
                                    entities.set(i, mob);
                                }
                            } else if (entity instanceof Wolf && (doggo = (Wolf)entity).getOwner() instanceof Player) {
                                doggo.setCustomName(doggo.getOwner().getName() + "'s Doggo");
                                LivingEntity mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                if (!effects.isEmpty()) {
                                    Iterator iterator = effects.iterator();
                                    while (iterator.hasNext()) {
                                        int pid = (Integer)iterator.next();
                                        poData = ScheduledMobs.this.po.getDrinkableDataById(pid);
                                        for (PotionEffectType effect : poData.effectTypes) {
                                            mob.addPotionEffect(new PotionEffect(effect, Integer.MAX_VALUE, poData.amplifier, true));
                                        }
                                    }
                                }
                                entities.set(i, mob);
                            }
                            ++i;
                        }
                        while (entities.size() < maxEntities) {
                            if (ScheduledMobs.this.debugging) {
                                ScheduledMobs.this.plugin.getLogger().info(String.valueOf(entities.size()) + "Not enough entities, looping to add more...");
                            }
                            LivingEntity mob = null;
                            if (chance != 0) {
                                Random rand = new Random();
                                if (rand.nextInt(chance + 1) == 1 || ScheduledMobs.this.debugging) {
                                    ItemStack item = new ItemStack(Material.matchMaterial((String)weapon), 1);
                                    ItemMeta meta = item.getItemMeta();
                                    if (meta instanceof Damageable) {
                                        ((Damageable)meta).setDamage(dura);
                                    }
                                    mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                    mob.getEquipment().setItemInMainHand(item);
                                    entities.add(mob);
                                    continue;
                                }
                                mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                                entities.add(mob);
                                continue;
                            }
                            mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(location, EntityType.valueOf((String)entityType));
                            entities.add(mob);
                        }
                        ScheduledMobs.this.spawners.put(location, entities);
                    }
                    d += 9;
                }
            }
        }, 20L, 400L);
    }
}

