/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.MSTeam;
import com.mineswarm.TeamBoards;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MineswarmTeams {
    public Plugin plugin;
    public HashMap<UUID, BukkitTask> tpQueue = new HashMap();
    private HashMap<String, MSTeam> closedTeams = new HashMap();
    private ArrayList<MSTeam> openTeams = new ArrayList();
    private HashMap<UUID, MSTeam> players = new HashMap();
    private HashMap<String, MSTeam> joinRequests = new HashMap();
    private TeamBoards board;
    private Database db = null;

    public MineswarmTeams(Plugin instance, TeamBoards board) {
        this.plugin = instance;
        this.board = board;
        this.db = new Database(this.plugin);
    }

    public boolean loadTeamData() {
        HashMap<Integer, MSTeam> teams;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block19: {
            conn = this.db.connect();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            pstmt = null;
            rs = null;
            teams = new HashMap<Integer, MSTeam>();
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT name, owner, closed, score, rowid as id FROM teams");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        UUID id;
                        try {
                            id = UUID.fromString(rs.getString("owner"));
                        }
                        catch (IllegalArgumentException iae) {
                            id = UUID.fromString("053573d9-85a4-4b1a-80b3-c86d08071f24");
                        }
                        catch (NullPointerException npr) {
                            id = UUID.fromString("053573d9-85a4-4b1a-80b3-c86d08071f24");
                        }
                        MSTeam team = new MSTeam(rs.getString("name"), id, rs.getBoolean("closed"), rs.getInt("score"));
                        if (rs.getBoolean("closed")) {
                            this.closedTeams.put(team.getName(), team);
                        } else {
                            this.openTeams.add(team);
                        }
                        teams.put(rs.getInt("id"), team);
                        this.board.createScoreBoard(team.getName());
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error loading team data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        conn = this.db.connect();
        if (conn == null) {
            this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
        }
        pstmt = null;
        rs = null;
        try {
            try {
                pstmt = conn.prepareStatement("SELECT * FROM members");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MSTeam cur_team = (MSTeam)teams.get(rs.getInt("team_id"));
                    UUID cur_player = UUID.fromString(rs.getString("member"));
                    cur_team.addMember(cur_player);
                    this.players.put(cur_player, cur_team);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning(String.format("Error getting team member data: ", e.getMessage()));
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
            }
        }
        finally {
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return true;
    }

    public boolean saveTeamData() {
        int team_id;
        this.db.emptyTeamsTable();
        for (Map.Entry<String, MSTeam> entry : this.closedTeams.entrySet()) {
            team_id = this.db.updateTeamsTable(entry.getValue().getName(), entry.getValue().getOwner().toString(), entry.getValue().isClosed(), entry.getValue().getScore());
            for (UUID playerID : entry.getValue().getMembers()) {
                this.db.insertNewTeamMember(playerID.toString(), team_id);
            }
        }
        for (MSTeam mSTeam : this.openTeams) {
            team_id = this.db.updateOpenTeams(mSTeam.getName(), mSTeam.isClosed(), mSTeam.getScore());
            for (UUID playerID : mSTeam.getMembers()) {
                this.db.insertMembers(playerID.toString(), team_id);
            }
        }
        return true;
    }

    public MSTeam createOpenTeam(Player player) {
        try {
            String name = UUID.randomUUID().toString();
            MSTeam newTeam = new MSTeam(name, false);
            this.openTeams.add(newTeam);
            try {
                this.board.createScoreBoard(name);
                this.board.updateScoreBoard(newTeam.getMembersPlayerObjects(), name, player);
            }
            catch (NullPointerException npe) {
                this.plugin.getLogger().warning("Null value present in setScoreboard function (1b). " + npe.toString());
            }
            catch (IllegalArgumentException iae) {
                this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (1b). " + iae.toString());
            }
            catch (IllegalStateException ise) {
                this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (1b). " + ise.toString());
            }
            catch (Exception err) {
                this.plugin.getLogger().info("Problem making team " + err.toString());
            }
            return newTeam;
        }
        catch (Exception err) {
            this.plugin.getLogger().info("Problem with making server team: " + err.toString());
            return null;
        }
    }

    public MSTeam getTeam(Player player) {
        MSTeam team = this.players.get(player.getUniqueId());
        return team;
    }

    public boolean createClosedTeam(String name, Player player) {
        block10: {
            block11: {
                try {
                    if (this.closedTeams.get(name) != null) break block10;
                    UUID playerID = player.getUniqueId();
                    if (this.players.get(playerID) != null) break block11;
                    MSTeam newTeam = new MSTeam(name);
                    newTeam.addMember(playerID);
                    newTeam.newOwner(playerID);
                    this.closedTeams.put(name, newTeam);
                    this.players.put(player.getUniqueId(), newTeam);
                    if (this.plugin.getConfig().getBoolean("creating-team-takes-to-spawn")) {
                        player.teleport(player.getWorld().getSpawnLocation());
                    }
                    try {
                        this.board.createScoreBoard(name);
                        this.board.updateScoreBoard(newTeam.getMembersPlayerObjects(), name, player);
                    }
                    catch (NullPointerException npe) {
                        this.plugin.getLogger().warning("Null value present in setScoreboard function (1b). " + npe.toString());
                    }
                    catch (IllegalArgumentException iae) {
                        this.plugin.getLogger().warning("Illegal Argument present in setScoreboard function (1b). " + iae.toString());
                    }
                    catch (IllegalStateException ise) {
                        this.plugin.getLogger().warning("Illegal State in setScoreboard function, objective has been unregistered (1b). " + ise.toString());
                    }
                    catch (Exception err) {
                        this.plugin.getLogger().info("Problem making team " + err.toString());
                    }
                    return true;
                }
                catch (Exception err) {
                    this.plugin.getLogger().info("Problem with making team: " + err.toString());
                    return false;
                }
            }
            player.sendMessage("You cannot join a team without first leaving the team you are in.");
            return false;
        }
        player.sendMessage("Team name already exists, please try something else");
        return false;
    }

    public MSTeam getTeamByName(String name) {
        MSTeam team = this.closedTeams.get(name);
        if (team == null) {
            for (MSTeam oteam : this.openTeams) {
                if (oteam.getName() != name) continue;
                return oteam;
            }
            return null;
        }
        return team;
    }

    public boolean joinRandom(Player player) {
        for (MSTeam team : this.openTeams) {
            if (team.getMembers().size() > this.plugin.getConfig().getInt("max-team-size") + 1) continue;
            this.updateTeamInfo(player, team);
            this.openTeams.add(team);
            player.sendMessage("You have joined a server-owned team!");
            return true;
        }
        this.updateTeamInfo(player, this.createOpenTeam(player));
        player.sendMessage("You have joined a server-owned team!");
        return true;
    }

    public ArrayList<String> getMemberNames(Player player) {
        MSTeam team = this.players.get(player.getUniqueId());
        if (team != null) {
            return team.getMembersNames();
        }
        return null;
    }

    private boolean updateTeamInfo(Player player, MSTeam team) {
        UUID playerID = player.getUniqueId();
        this.players.put(playerID, team);
        team.addMember(playerID);
        this.players.put(player.getUniqueId(), team);
        this.board.updateScoreBoard(team.getMembersPlayerObjects(), team.getName(), player);
        return true;
    }

    public void addRandomTPAQue(Player player) {
        this.tpQueue.put(player.getUniqueId(), Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            MSTeam team = this.players.get(player.getUniqueId());
            ArrayList<Player> onlineTeamMates = team.getOnlineMembersPlayerObjects();
            onlineTeamMates.remove(player);
            if (onlineTeamMates.size() <= 0) {
                player.sendMessage("No teamate are online but you");
            } else {
                player.teleport((Entity)onlineTeamMates.get(ThreadLocalRandom.current().nextInt(0, onlineTeamMates.size())));
            }
            this.tpQueue.get(player.getUniqueId()).cancel();
            this.tpQueue.remove(player.getUniqueId());
        }, 300L, 200L));
    }

    public boolean addTPAQue(Player player, String toPlayer) {
        this.tpQueue.put(player.getUniqueId(), Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            Player to = Bukkit.getPlayer((String)toPlayer);
            if (to != null && to.isOnline()) {
                MSTeam team = this.players.get(player.getUniqueId());
                if (team.getMembersPlayerObjects().contains(to)) {
                    player.teleport((Entity)to);
                } else {
                    player.sendMessage("Player is not on your team.");
                }
            } else {
                player.sendMessage("Player is offline or could not be found.");
            }
            this.tpQueue.get(player.getUniqueId()).cancel();
            this.tpQueue.remove(player.getUniqueId());
        }, 300L, 200L));
        return true;
    }

    public void alertTeamOfDowns(String teamName, Player downedPlayer) {
        MSTeam team = this.players.get(downedPlayer.getUniqueId());
        if (team != null) {
            ArrayList<Player> teamMates = team.getMembersPlayerObjects();
            for (Player player : teamMates) {
                try {
                    if (!player.isOnline() || player == downedPlayer) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + downedPlayer.getName() + " IS DOWN");
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void sendTeamMessage(Player player, String message) {
        MSTeam team = this.players.get(player.getUniqueId());
        ArrayList<Player> teamMates = team.getMembersPlayerObjects();
        for (Player teammate : teamMates) {
            try {
                if (!teammate.isOnline()) continue;
                teammate.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.BOLD) + message);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void sendTeamMessage(String message, Player exclude) {
        MSTeam team = this.players.get(exclude.getUniqueId());
        if (team != null) {
            for (Player player : team.getMembersPlayerObjects()) {
                try {
                    if (!player.isOnline() || player == exclude) continue;
                    player.sendMessage(String.valueOf(ChatColor.DARK_GREEN) + String.valueOf(ChatColor.BOLD) + message);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public Player getPlayerByUUID(UUID id) {
        return Bukkit.getPlayer((UUID)id);
    }

    public boolean joinRequest(Player player, String team_name) {
        if (this.players.get(player.getUniqueId()) == null) {
            MSTeam team = this.closedTeams.get(team_name);
            if (team != null) {
                if (team.getMembers().size() < this.plugin.getConfig().getInt("max-team-size")) {
                    try {
                        Bukkit.getPlayer((UUID)team.getOwner()).sendMessage("Player " + player.getName() + " is requesting to join your team. /msteam add " + player.getName() + " to add the player or /msteam deny " + player.getName() + " to deny.");
                    }
                    catch (Exception er) {
                        this.plugin.getLogger().info("FICL OFF " + er.toString());
                    }
                    this.joinRequests.put(player.getName(), team);
                    player.sendMessage("Join request sent, waiting for approval...");
                    return true;
                }
                player.sendMessage("Team is full.");
                return false;
            }
            player.sendMessage("Team does not exist");
            return false;
        }
        player.sendMessage("You are already part of a team, leave that team before joining a new one");
        return false;
    }

    public boolean joinTeamAccept(Player player, String playerName) {
        MSTeam team = this.joinRequests.get(playerName);
        if (team != null) {
            if (team.getOwner() == player.getUniqueId()) {
                Player joinee = Bukkit.getPlayer((String)playerName);
                if (joinee != null && joinee.isOnline()) {
                    this.updateTeamInfo(Bukkit.getPlayer((String)playerName), team);
                    this.joinRequests.remove(playerName);
                    return true;
                }
                player.sendMessage("Player is offline, please try again when they are online.");
                return false;
            }
            player.sendMessage("You are not the owner of this team.");
            return false;
        }
        player.sendMessage("Team no longer exist.");
        return false;
    }

    public boolean joinTeamDeny(Player player, String playerName) {
        MSTeam team = this.joinRequests.get(playerName);
        if (team != null) {
            if (team.getOwner() == player.getUniqueId()) {
                Player joinee = Bukkit.getPlayer((String)playerName);
                if (joinee != null && joinee.isOnline()) {
                    this.joinRequests.remove(playerName);
                    Bukkit.getPlayer((String)playerName).sendMessage("Team Join Request was denied.");
                    return true;
                }
                player.sendMessage("Player is offline, try again when they are online.");
                return false;
            }
            player.sendMessage("You are not the owner of this team.");
            return false;
        }
        player.sendMessage("Team no longer exist.");
        return false;
    }

    private boolean updateRemoveTeamInfo(Player player, MSTeam team, Boolean kicked) {
        this.players.remove(player.getUniqueId());
        if (kicked.booleanValue()) {
            player.sendMessage("You were kicked from the team");
        } else {
            player.sendMessage("You have left the team");
        }
        team.removeMember(player.getUniqueId());
        this.board.updateScoreBoard(team.getMembersPlayerObjects(), team.getName(), player);
        if (this.plugin.getConfig().getBoolean("leaving-team-takes-to-spawn")) {
            player.teleport(player.getWorld().getSpawnLocation());
        }
        this.board.removeScoreboard(player, team);
        this.board.updateScoreBoard(team.getMembersPlayerObjects(), team.getName());
        return true;
    }

    public boolean leaveTeam(Player player, Boolean kicked) {
        MSTeam team = this.players.get(player.getUniqueId());
        if (team != null) {
            if (team.getOwner() == player.getUniqueId()) {
                team.newOwner();
                this.updateRemoveTeamInfo(player, team, kicked);
                if (team.getMembers().size() <= 0) {
                    this.closedTeams.remove(team.getName());
                }
                return true;
            }
            this.updateRemoveTeamInfo(player, team, kicked);
            if (team.getMembers().size() <= 0) {
                this.closedTeams.remove(team.getName());
            }
            return true;
        }
        player.sendMessage("You are not part of a team.");
        return false;
    }

    public boolean kickTeamMember(String kicky, Player kicker) {
        MSTeam team = this.players.get(kicker.getUniqueId());
        if (team.getOwner() == kicker.getUniqueId()) {
            if (team.getMembersNames().contains(kicky)) {
                Player kickyPlayer = Bukkit.getPlayer((String)kicky);
                if (kickyPlayer != null && kickyPlayer.isOnline()) {
                    if (kickyPlayer.getUniqueId() != team.getOwner()) {
                        this.leaveTeam(kickyPlayer, true);
                        return true;
                    }
                    kicker.sendMessage("yOu CaNnOt KiCk YoUrSeLf...");
                    return false;
                }
                kicker.sendMessage("Player is offline. Try again when they are online.");
                return false;
            }
            kicker.sendMessage("Player is not a member of your team.");
            return false;
        }
        kicker.sendMessage("You are not the team owner.");
        return false;
    }
}

