/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.EventListener;
import com.mineswarm.JavaHelper;
import com.mineswarm.Kits;
import com.mineswarm.MSPlayer;
import com.mineswarm.MakePotion;
import com.mineswarm.MineswarmTeams;
import com.mineswarm.PotionObjects;
import com.mineswarm.ScheduledChests;
import com.mineswarm.ScheduledMobs;
import com.mineswarm.TeamBoards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.material.Openable;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class Mineswarm
extends JavaPlugin
implements Listener {
    public final String version = "1.18.0";
    private HashMap<UUID, MSPlayer> msplayers = new HashMap();
    private Database db = null;
    private PotionObjects potions = new PotionObjects();
    private Kits kits = new Kits((Plugin)this, this.potions, this.msplayers);
    private TeamBoards board = new TeamBoards((Plugin)this);
    private MineswarmTeams teams = new MineswarmTeams((Plugin)this, this.board);
    private ScheduledMobs smobs = new ScheduledMobs((Plugin)this, this.potions);

    public void onEnable() {
        this.getLogger().info(String.format("Mineswarm Version %s is starting...", "1.18.0"));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Mineswarm has been Registered");
        new EventListener((Plugin)this, this.teams, this.board, this.potions, this.msplayers, this.kits);
        this.getLogger().info("Mineswarm Event Listen has started for Teams");
        new ScheduledChests((Plugin)this, this.potions);
        this.getLogger().info("Mineswarm Scheduler has started for Chests");
        this.saveDefaultConfig();
        this.getLogger().info("Mineswarm Default Config has been saved");
        this.db = new Database((Plugin)this);
        this.getLogger().info("Mineswarm Databases have been started...");
        this.db.setupDatabases();
        this.getLogger().info("Mineswarm all Databases have been enabled");
        this.getLogger().info("Mineswarm finished Databases...");
        this.smobs.startMobs();
        this.getLogger().info("Mineswarm Scheduled Mob spawns have been enabled");
        this.getLogger().info("Mineswarm Loading MSTeam data into program.");
        this.teams.loadTeamData();
        try {
            BlockState state = ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0).getRelative(BlockFace.DOWN).getState();
            state.getBlock();
            Openable door = (Openable)state.getData();
            door.isOpen();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getCommand("makespawner").setExecutor((CommandExecutor)this);
        this.getLogger().info("Mineswarm Loaded MSTeam data.");
        this.getLogger().info("Mineswarm has been enabled!");
    }

    public void onDisable() {
        this.teams.saveTeamData();
        this.getLogger().info("Mineswarm has been disabled");
    }

    private void getDoorLevel(Player player) {
        Block block = player.getTargetBlock(null, 100);
        Location bl = block.getLocation();
        player.sendMessage(bl.toString());
    }

    private void getTool(Player player) {
        ItemStack markingTool = new ItemStack(Material.GOLDEN_HOE, 1);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("Marking Tool: Left click POS1, Right click POS2");
        ItemMeta meta = markingTool.getItemMeta();
        meta.setDisplayName("MCMS Marking Tool");
        if (meta.hasLore()) {
            meta.getLore().add("Marking Tool: Left click POS1, Right click POS2");
        } else {
            meta.setLore(lore);
        }
        markingTool.setItemMeta(meta);
        player.getLocation().getWorld().dropItem(player.getLocation(), markingTool);
    }

    private void gotoZone(Player player, String arg) {
        try {
            List<String> zoneData = this.db.tpToZone(arg);
            if (zoneData.size() >= 1) {
                Location location = new Location(Bukkit.getWorld((String)zoneData.get(0)), (double)Integer.valueOf(zoneData.get(1)).intValue(), (double)Integer.valueOf(zoneData.get(2)).intValue(), (double)Integer.valueOf(zoneData.get(3)).intValue());
                player.teleport(location);
            }
            return;
        }
        catch (Exception er) {
            player.sendMessage("Error on show location/s: " + er.toString());
            return;
        }
    }

    private void setClass(Player player, String itemClass) {
        try {
            if (!this.kits.giveKit(player, itemClass)) {
                player.sendMessage("You can't use more than 1 class, die to pick a new class >:)");
                return;
            }
        }
        catch (Exception er) {
            player.sendMessage("Error on class command: " + er.toString());
            return;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        block142: {
            int blockY;
            Block block;
            player = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("doorlevel") && sender instanceof Player) {
                this.getDoorLevel(player);
            }
            if (cmd.getName().equalsIgnoreCase("markingtool") && sender instanceof Player) {
                this.getTool(player);
            }
            if (cmd.getName().equalsIgnoreCase("gotozone") && sender instanceof Player) {
                this.gotoZone(player, args[0]);
            }
            if (cmd.getName().equalsIgnoreCase("class")) {
                this.setClass(player, args[0]);
            }
            if (cmd.getName().equalsIgnoreCase("msteam") && sender instanceof Player && args.length <= 0) {
                player.sendMessage("Type /msteam help for help. No subcommand given.");
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("PotionTypes")) {
                PotionType[] potionTypeArray = PotionType.values();
                int n = potionTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PotionType x = potionTypeArray[n2];
                    player.sendMessage(x.toString());
                    ++n2;
                }
            }
            if (cmd.getName().equalsIgnoreCase("showzone") && sender instanceof Player) {
                try {
                    List<String> zoneData = this.db.showZone(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ(), player.getLocation().getWorld().toString());
                    for (String x : zoneData) {
                        player.sendMessage(x);
                    }
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on show location/s: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("makezone") && sender instanceof Player) {
                try {
                    if (player.hasMetadata("pos1x") && player.hasMetadata("pos1z") && player.hasMetadata("pos1y") && player.hasMetadata("pos2z") && player.hasMetadata("pos2x") && player.hasMetadata("pos2y") && player.hasMetadata("world1") && player.hasMetadata("world2")) {
                        int min_y;
                        int max_y;
                        int min_z;
                        int max_z;
                        int min_x;
                        int max_x;
                        if (!((MetadataValue)player.getMetadata("world1").get(0)).asString().equals(((MetadataValue)player.getMetadata("world2").get(0)).asString())) {
                            player.sendMessage("You cannot set a single zone that spans multiple worlds.");
                            player.sendMessage(((MetadataValue)player.getMetadata("world1").get(0)).asString());
                            player.sendMessage(((MetadataValue)player.getMetadata("world2").get(0)).asString());
                        }
                        if (((MetadataValue)player.getMetadata("pos1x").get(0)).asInt() > ((MetadataValue)player.getMetadata("pos2x").get(0)).asInt()) {
                            max_x = ((MetadataValue)player.getMetadata("pos1x").get(0)).asInt();
                            min_x = ((MetadataValue)player.getMetadata("pos2x").get(0)).asInt();
                        } else {
                            max_x = ((MetadataValue)player.getMetadata("pos2x").get(0)).asInt();
                            min_x = ((MetadataValue)player.getMetadata("pos1x").get(0)).asInt();
                        }
                        if (((MetadataValue)player.getMetadata("pos1z").get(0)).asInt() > ((MetadataValue)player.getMetadata("pos2z").get(0)).asInt()) {
                            max_z = ((MetadataValue)player.getMetadata("pos1z").get(0)).asInt();
                            min_z = ((MetadataValue)player.getMetadata("pos2z").get(0)).asInt();
                        } else {
                            max_z = ((MetadataValue)player.getMetadata("pos2z").get(0)).asInt();
                            min_z = ((MetadataValue)player.getMetadata("pos1z").get(0)).asInt();
                        }
                        if (((MetadataValue)player.getMetadata("pos1y").get(0)).asInt() > ((MetadataValue)player.getMetadata("pos2y").get(0)).asInt()) {
                            max_y = ((MetadataValue)player.getMetadata("pos1y").get(0)).asInt();
                            min_y = ((MetadataValue)player.getMetadata("pos2y").get(0)).asInt();
                        } else {
                            max_y = ((MetadataValue)player.getMetadata("pos2y").get(0)).asInt();
                            min_y = ((MetadataValue)player.getMetadata("pos1y").get(0)).asInt();
                        }
                        this.db.makeZone(args[0].replace("_", " "), min_x, min_y, min_z, max_x, max_y, max_z, args[1].replace("_", " "), player.getName(), ((MetadataValue)player.getMetadata("world1").get(0)).asString(), Boolean.valueOf(args[2]), Integer.valueOf(args[3]));
                        return true;
                    }
                    player.sendMessage("One of the positions is not set, please set both positions before displaying zone");
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on show location/s: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("makedoor") && sender instanceof Player) {
                try {
                    block = player.getTargetBlock(null, 10);
                    String blockID = "X:" + String.valueOf(block.getX()) + "Z:" + String.valueOf(block.getZ()) + "W:" + String.valueOf(block.getWorld());
                    blockY = block.getY();
                    this.db.makeDoor(blockID, blockY, args[0].replace("_", " "), player.getName());
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on show location/s: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("deletedoor") && sender instanceof Player) {
                try {
                    block = player.getTargetBlock(null, 10);
                    String blockID = "X:" + String.valueOf(block.getX()) + "Z:" + String.valueOf(block.getZ()) + "W:" + String.valueOf(block.getWorld());
                    blockY = block.getY();
                    this.db.deleteDoor(blockID, blockY, player.getName());
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on show location/s: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("destroydoor") && sender instanceof Player) {
                try {
                    block = player.getTargetBlock(null, 10);
                    String blockID = "X:" + String.valueOf(block.getX()) + "Z:" + String.valueOf(block.getZ()) + "W:" + String.valueOf(block.getWorld());
                    blockY = block.getY();
                    this.db.destroyDoor(blockID, blockY);
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on show location/s: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("makespawner") && sender instanceof Player) {
                try {
                    LivingEntity mob;
                    block = player.getTargetBlock(null, 10);
                    String xyz = block.getX() + "," + block.getY() + "," + block.getZ();
                    String world = player.getWorld().getName();
                    try {
                        mob = (LivingEntity)Bukkit.getWorld((String)world).spawnEntity(block.getLocation(), EntityType.valueOf((String)args[0].toUpperCase()));
                    }
                    catch (Exception err) {
                        player.sendMessage("Unrecognized Mob type.");
                        return true;
                    }
                    if (args.length == 2) {
                        this.db.makeSpawner(xyz, world, args[0].toUpperCase(), Integer.valueOf(args[1]), "NONE", 0, 0, null, null);
                        return true;
                    }
                    ArrayList<String> enchantments = new ArrayList<String>();
                    ArrayList<String> effects = new ArrayList<String>();
                    String weapon = "NONE";
                    int i = 0;
                    while (i < args.length) {
                        if (JavaHelper.countMatches(args[i].toLowerCase(), "enchantment:") >= 1) {
                            enchantments.add(args[i].toUpperCase().replaceAll("enchantment:".toUpperCase(), "") + ":" + args[i + 1]);
                        }
                        if (JavaHelper.countMatches(args[i].toLowerCase(), "potion:") >= 1) {
                            effects.add(args[i].toUpperCase().replaceAll("potion:".toUpperCase(), ""));
                        }
                        if (JavaHelper.countMatches(args[i].toLowerCase(), "weapon:") >= 1) {
                            weapon = args[i].toUpperCase().replaceAll("weapon:".toUpperCase(), "");
                        }
                        ++i;
                    }
                    if (!effects.isEmpty()) {
                        for (String pid : effects) {
                            MakePotion poData = this.potions.getDrinkableDataById(Integer.valueOf(pid));
                            for (PotionEffectType effect : poData.effectTypes) {
                                mob.addPotionEffect(new PotionEffect(effect, Integer.MAX_VALUE, poData.amplifier, true));
                            }
                        }
                    }
                    if (weapon == "NONE") {
                        try {
                            Integer.valueOf(args[1]);
                        }
                        catch (Exception intError) {
                            player.sendMessage("No number of mobs given.");
                            return true;
                        }
                        this.db.makeSpawner(xyz, world, args[0].toUpperCase(), Integer.valueOf(args[1]), weapon, 0, 0, enchantments, effects);
                        return true;
                    }
                    try {
                        ItemStack item = new ItemStack(Material.matchMaterial((String)weapon), 1);
                        ItemMeta meta = item.getItemMeta();
                        if (meta instanceof Damageable) {
                            ((Damageable)meta).setDamage((int)Short.valueOf(args[4]).shortValue());
                        }
                        if (!enchantments.isEmpty()) {
                            for (String enchantment : enchantments) {
                                String[] en = enchantment.split(":");
                                item.addEnchantment(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)en[0].toLowerCase())), Integer.valueOf(en[1]).intValue());
                            }
                        }
                    }
                    catch (Exception err) {
                        player.sendMessage("Failed to add enchantment to weapon");
                        return true;
                    }
                    this.db.makeSpawner(xyz, world, args[0].toUpperCase(), Integer.valueOf(args[1]), weapon, Integer.valueOf(args[3]), Integer.valueOf(args[4]), enchantments, effects);
                }
                catch (Exception err) {
                    this.getLogger().info(err.toString() + " IN COMMAND MAKESPAWNER");
                }
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("chest") && sender instanceof Player) {
                Chest chest;
                try {
                    Block block2 = player.getTargetBlock(null, 10);
                    chest = (Chest)block2.getState();
                }
                catch (Exception err) {
                    player.sendMessage("That block could not be casted as a chest.");
                    return true;
                }
                if (args.length <= 1) {
                    player.sendMessage("Arguments must be ITEM QUANTITY such as: DIRT 12");
                    return false;
                }
                if ((args.length & 1) != 0) {
                    player.sendMessage("Missing argumenets, args should be ITEM QUANTITY");
                    return false;
                }
                try {
                    Object items = "";
                    int i = 0;
                    while (i < args.length) {
                        ItemStack toAdd = null;
                        try {
                            int pID = Integer.valueOf(args[i]);
                            MakePotion potionData = this.potions.getDrinkableDataById(pID);
                            toAdd = potionData.isSplash ? new ItemStack(Material.SPLASH_POTION, Integer.valueOf(args[i + 1].toString()).intValue()) : new ItemStack(Material.POTION, Integer.valueOf(args[i + 1].toString()).intValue());
                            try {
                                ItemMeta im = toAdd.getItemMeta();
                                im.setDisplayName(potionData.name);
                                PotionMeta pm = (PotionMeta)im;
                                for (PotionEffectType effect : potionData.effectTypes) {
                                    pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                                }
                                pm.setColor(potionData.color);
                                toAdd.setItemMeta(im);
                            }
                            catch (Exception err) {
                                this.getLogger().info("ERROR : " + err.toString());
                            }
                        }
                        catch (NumberFormatException nfe) {
                            try {
                                try {
                                    int pID = Integer.valueOf(args[i].toString().replaceAll("TIPPED_ARROW:", ""));
                                    MakePotion potionData = this.potions.getDrinkableDataById(pID);
                                    if (args[i].toUpperCase().contains("TIPPED_ARROW:")) {
                                        toAdd = new ItemStack(Material.TIPPED_ARROW, Integer.valueOf(args[i + 1]).intValue());
                                        ItemMeta im = toAdd.getItemMeta();
                                        PotionMeta pm = (PotionMeta)im;
                                        im.setDisplayName(potionData.name);
                                        for (PotionEffectType effect : potionData.effectTypes) {
                                            pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                                        }
                                        pm.setColor(potionData.color);
                                        toAdd.setItemMeta(im);
                                    }
                                }
                                catch (NumberFormatException nfe2) {
                                    toAdd = new ItemStack(Material.getMaterial((String)args[i].toString()), Integer.valueOf(args[i + 1]).intValue());
                                }
                            }
                            catch (Exception problem) {
                                player.sendMessage("Could not convert one of more of the args to an item stack.");
                                return false;
                            }
                        }
                        catch (Exception err) {
                            player.sendMessage("Could not convert one of more of the args to an item stack.");
                            return false;
                        }
                        i += 2;
                    }
                    String[] stringArray = args;
                    int n = args.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String item = stringArray[n3];
                        items = (String)items + item + ",";
                        ++n3;
                    }
                    items = ((String)items).replaceAll(",$", "");
                    this.db.createChest(chest.getX(), chest.getY(), chest.getZ(), chest.getWorld().getName(), player.getName(), (String)items);
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error ON INSERT: " + er.toString());
                }
            }
            if (cmd.getName().equalsIgnoreCase("inhand")) {
                try {
                    player.sendMessage(player.getInventory().getItemInMainHand().getType().toString());
                }
                catch (Exception er) {
                    player.sendMessage("Error on class command: " + er.toString());
                    return false;
                }
            }
            if (cmd.getName().equalsIgnoreCase("makebutton")) {
                try {
                    block = player.getTargetBlock(null, 10);
                    if (!block.getType().equals((Object)Material.JUNGLE_BUTTON)) break block142;
                    try {
                        this.db.saveButton(block.getLocation(), args[0]);
                    }
                    catch (Exception e) {
                        this.getLogger().warning(e.toString());
                    }
                    return true;
                }
                catch (Exception er) {
                    player.sendMessage("Error on button make command: " + er.toString());
                    return false;
                }
            }
        }
        if (cmd.getName().equalsIgnoreCase("team") && sender instanceof Player) {
            player.sendMessage("Native teams are disbaled, try msteam instead.");
            return true;
        }
        switch (args[0]) {
            case "tpr": {
                if (this.teams.tpQueue.get(player.getUniqueId()) != null) {
                    this.teams.tpQueue.get(player.getUniqueId()).cancel();
                    this.teams.tpQueue.remove(player.getUniqueId());
                }
                this.teams.addRandomTPAQue(player);
                player.sendMessage("You will be TPed in ~20 seconds, do not move or this will be cancelled");
                break;
            }
            case "tpp": {
                if (this.teams.tpQueue.get(player.getUniqueId()) != null) {
                    this.teams.tpQueue.get(player.getUniqueId()).cancel();
                    this.teams.tpQueue.remove(player.getUniqueId());
                }
                this.teams.addTPAQue(player, args[1]);
                player.sendMessage("You will be TPed in ~20 seconds, do not move or this will be cancelled");
                break;
            }
            case "no": {
                this.teams.tpQueue.get(player.getUniqueId()).cancel();
                break;
            }
            case "join": {
                try {
                    this.teams.joinRequest(player, args[1]);
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter a team name you want to join");
                    break;
                }
            }
            case "joinr": {
                this.teams.joinRandom(player);
                return true;
            }
            case "add": {
                try {
                    this.teams.joinTeamAccept(player, args[1]);
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter the player name you want to let join");
                    break;
                }
            }
            case "deny": {
                try {
                    this.teams.joinTeamDeny(player, args[1]);
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter the player name you want to deny joining");
                    break;
                }
            }
            case "leave": {
                try {
                    this.teams.leaveTeam(player, false);
                    return true;
                }
                catch (Exception exc) {
                    player.sendMessage("Error: " + exc.toString());
                    break;
                }
            }
            case "create": {
                try {
                    this.teams.createClosedTeam(args[1], player);
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter a team name you want to create");
                    break;
                }
            }
            case "kick": {
                try {
                    this.teams.kickTeamMember(args[1], player);
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter the player name you want to kick.");
                    break;
                }
            }
            case "list": {
                try {
                    ArrayList<String> members = this.teams.getMemberNames(player);
                    for (String name : members) {
                        player.sendMessage(name);
                    }
                    if (members == null) {
                        player.sendMessage("Couldn't find any team members.");
                    }
                    return true;
                }
                catch (IndexOutOfBoundsException ib) {
                    player.sendMessage("Please enter the player name you want to kick.");
                    break;
                }
            }
            case "save": {
                try {
                    this.teams.saveTeamData();
                    return true;
                }
                catch (Exception exc) {
                    player.sendMessage("Problem saving: " + exc.toString());
                    break;
                }
            }
            default: {
                player.sendMessage("Invalid subcommand, type /help mineswarm for command details.");
            }
        }
        return false;
    }
}

