/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MSTeam {
    private String name;
    private ArrayList<UUID> members = new ArrayList();
    private UUID owner;
    private boolean closed = true;
    private int score = 0;

    public MSTeam(String name) {
        this.name = name;
    }

    public MSTeam(String name, boolean closed) {
        this.name = name;
        this.closed = closed;
    }

    public MSTeam(String name, UUID owner, boolean closed, int score) {
        this.name = name;
        this.owner = owner;
        this.closed = closed;
        this.score = score;
    }

    public String getName() {
        return this.name;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean newOwner() {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (UUID id : this.members) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline() || player.getUniqueId() == this.owner) continue;
            onlinePlayers.add(player);
        }
        if (onlinePlayers.size() > 0) {
            int rnd = new Random().nextInt(onlinePlayers.size() - 1);
            this.owner = ((Player)onlinePlayers.get(rnd)).getUniqueId();
            return true;
        }
        return false;
    }

    public boolean newOwner(UUID player) {
        if (this.members.contains(player)) {
            this.owner = player;
            return true;
        }
        return false;
    }

    public ArrayList<UUID> getMembers() {
        return this.members;
    }

    public ArrayList<String> getMembersNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        for (UUID id : this.members) {
            try {
                playerNames.add(Bukkit.getPlayer((UUID)id).getName());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return playerNames;
    }

    public ArrayList<Player> getMembersPlayerObjects() {
        ArrayList<Player> playerObjects = new ArrayList<Player>();
        for (UUID id : this.members) {
            try {
                playerObjects.add(Bukkit.getPlayer((UUID)id));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return playerObjects;
    }

    public ArrayList<Player> getOnlineMembersPlayerObjects() {
        ArrayList<Player> playerObjects = new ArrayList<Player>();
        for (UUID id : this.members) {
            Player player = Bukkit.getPlayer((UUID)id);
            if (player == null || !player.isOnline()) continue;
            playerObjects.add(player);
        }
        return playerObjects;
    }

    public void addMember(UUID playerUUID) {
        this.members.add(playerUUID);
    }

    public boolean removeMember(UUID playerUUID) {
        this.members.remove(playerUUID);
        return true;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void addScore(int score) {
        this.score += score;
    }

    public void subtractScore(int score) {
        this.score -= score;
    }

    public int getScore() {
        return this.score;
    }
}

