/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.MSPlayer;
import com.mineswarm.MakePotion;
import com.mineswarm.PotionObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Kits {
    public Plugin plugin;
    public Database db = null;
    private PotionObjects potions = null;
    private HashMap<UUID, MSPlayer> msplayers;

    public Kits(Plugin instance, PotionObjects potions, HashMap<UUID, MSPlayer> msplayers) {
        this.plugin = instance;
        this.db = new Database(this.plugin);
        this.potions = potions;
        this.msplayers = msplayers;
    }

    public boolean giveKit(Player player, String kit) {
        MSPlayer msPlayer = this.msplayers.get(player.getUniqueId());
        if (msPlayer.getItemClass() != null) {
            return false;
        }
        ItemStack guideBook = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta bookMeta = (BookMeta)guideBook.getItemMeta();
        bookMeta.setTitle(this.plugin.getConfig().getString("guide-title"));
        bookMeta.setAuthor(this.plugin.getConfig().getString("guide-author"));
        ArrayList<String> pages = new ArrayList<String>();
        for (String page : this.plugin.getConfig().getStringList("guide-pages")) {
            if (page.length() > 256) {
                this.plugin.getLogger().info("Warnning, page in guide exceeds maximum number of characters (256) and will be shortened. Please split this page into two pages");
            }
            pages.add(page);
        }
        bookMeta.setPages(pages);
        guideBook.setItemMeta((ItemMeta)bookMeta);
        player.getInventory().addItem(new ItemStack[]{guideBook});
        List items = this.plugin.getConfig().getStringList(kit.toLowerCase() + "-class");
        for (String item : items) {
            try {
                List<String> stuff = Arrays.asList(item.split("\\s*,\\s*"));
                ItemStack toAdd = null;
                try {
                    int pID = Integer.valueOf(stuff.get(0).toString());
                    MakePotion potionData = this.potions.getDrinkableDataById(pID);
                    toAdd = potionData.isSplash ? new ItemStack(Material.SPLASH_POTION, Integer.valueOf(stuff.get(1).toString()).intValue()) : new ItemStack(Material.POTION, Integer.valueOf(stuff.get(1).toString()).intValue());
                    try {
                        ItemMeta im = toAdd.getItemMeta();
                        im.setDisplayName(potionData.name);
                        PotionMeta pm = (PotionMeta)im;
                        for (PotionEffectType effect : potionData.effectTypes) {
                            pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                        }
                        pm.setColor(potionData.color);
                        toAdd.setItemMeta(im);
                    }
                    catch (Exception err) {
                        this.plugin.getLogger().info("ERROR : " + err.toString());
                    }
                }
                catch (NumberFormatException nf) {
                    try {
                        int pID = Integer.valueOf(stuff.get(0).toString().replaceAll("TIPPED_ARROW:", ""));
                        MakePotion potionData = this.potions.getDrinkableDataById(pID);
                        if (stuff.get(0).toUpperCase().contains("TIPPED_ARROW:")) {
                            toAdd = new ItemStack(Material.TIPPED_ARROW, Integer.valueOf(stuff.get(1)).intValue());
                            ItemMeta im = toAdd.getItemMeta();
                            PotionMeta pm = (PotionMeta)im;
                            im.setDisplayName(potionData.name);
                            for (PotionEffectType effect : potionData.effectTypes) {
                                pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                            }
                            pm.setColor(potionData.color);
                            toAdd.setItemMeta(im);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        toAdd = new ItemStack(Material.getMaterial((String)stuff.get(0).toString()), Integer.valueOf(stuff.get(1)).intValue());
                    }
                }
                if (stuff.size() > 2) {
                    int i = 2;
                    while (i < stuff.size()) {
                        try {
                            if (toAdd.getType().equals((Object)Material.ENCHANTED_BOOK)) {
                                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)toAdd.getItemMeta();
                                esm.addStoredEnchant(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)stuff.get(i).toLowerCase())), Integer.valueOf(stuff.get(i + 1)).intValue(), true);
                                toAdd.setItemMeta((ItemMeta)esm);
                            } else {
                                toAdd.addUnsafeEnchantment(Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)stuff.get(i).toLowerCase())), Integer.valueOf(stuff.get(i + 1)).intValue());
                            }
                        }
                        catch (IndexOutOfBoundsException bounds) {
                            this.plugin.getLogger().info("Config misconfiguration at: " + stuff.get(0) + " Index is out of bounds for enchantments.");
                        }
                        catch (Exception err) {
                            this.plugin.getLogger().info("Unhandled Exception trying to make item enchantments: " + err.toString());
                        }
                        i += 2;
                    }
                }
                player.getInventory().addItem(new ItemStack[]{toAdd});
            }
            catch (Exception err) {
                this.plugin.getLogger().info("Failed to convert item: " + item + " to item stack.");
            }
        }
        if (items.size() > 0) {
            msPlayer.setItemClass(kit);
        }
        return true;
    }
}

