/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.MSPlayer;
import com.mineswarm.MSTeam;
import com.mineswarm.MineswarmTeams;
import com.mineswarm.TeamBoards;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class EventListenerHelper {
    private TeamBoards board = null;
    private MineswarmTeams teams = null;
    public Database db = null;
    HashMap<UUID, BukkitTask> downedPlayers;
    HashMap<UUID, MSPlayer> players;
    Plugin plugin;

    public EventListenerHelper(TeamBoards boards, MineswarmTeams teams, Database db, HashMap<UUID, MSPlayer> players, HashMap<UUID, BukkitTask> downedPlayers) {
        this.board = boards;
        this.teams = teams;
        this.db = db;
        this.downedPlayers = downedPlayers;
        this.players = players;
    }

    public EventListenerHelper(TeamBoards boards, MineswarmTeams teams, Database db, HashMap<UUID, MSPlayer> players, HashMap<UUID, BukkitTask> downedPlayers, Plugin plugin) {
        this.board = boards;
        this.teams = teams;
        this.db = db;
        this.downedPlayers = downedPlayers;
        this.players = players;
        this.plugin = plugin;
    }

    public void resetPlayerFromLastStand(Player player) {
        player.setWalkSpeed(0.2f);
        player.setGlowing(false);
        this.updateTeamBoard(player);
        BukkitTask downedTask = this.downedPlayers.get(player.getUniqueId());
        if (downedTask != null) {
            downedTask.cancel();
            this.downedPlayers.remove(player.getUniqueId());
        }
    }

    public void clearPlayerFromTPQue(Player player) {
        BukkitTask PlayerTPTask = this.teams.tpQueue.get(player.getUniqueId());
        if (PlayerTPTask != null) {
            PlayerTPTask.cancel();
            this.teams.tpQueue.remove(player.getUniqueId());
        }
    }

    public void updateTeamBoard(Player player) {
        MSTeam team = this.teams.getTeam(player);
        if (team != null) {
            this.board.updateScoreBoard(team.getMembersPlayerObjects(), team.getName(), player);
        }
    }

    public void updateTeamBoard(Player player, int health) {
        MSTeam team = this.teams.getTeam(player);
        if (team != null) {
            this.board.setScoreboard(team.getMembersPlayerObjects(), team.getName(), player, health);
        }
    }

    public boolean isPlayerDown(Player player) {
        return this.downedPlayers.get(player.getUniqueId()) != null;
    }

    public boolean isPlayerOnTeam(Player player) {
        return this.teams.getTeam(player) != null;
    }

    public void enviormentalOnPlayerDamage(EntityDamageEvent e) {
        Player player = (Player)e.getEntity();
        if (this.isPlayerDown(player)) {
            e.setCancelled(true);
            return;
        }
        if (player.getHealth() - e.getFinalDamage() <= 0.5) {
            e.setCancelled(true);
            this.setPlayerAsDown(player);
        }
        this.updateTeamBoard(player);
    }

    public void playerOnPlayerDamage(EntityDamageByEntityEvent e) {
        Player damagee = (Player)e.getEntity();
        Player damager = (Player)e.getDamager();
        BukkitTask downedDamager = this.downedPlayers.get(damager.getUniqueId());
        if (downedDamager != null) {
            e.setCancelled(true);
            return;
        }
        BukkitTask downedDamagee = this.downedPlayers.get(damagee.getUniqueId());
        if (downedDamagee != null && (damager.getInventory().getItemInMainHand().getType().equals((Object)Material.PLAYER_HEAD) || damager.getInventory().getItemInOffHand().getType().equals((Object)Material.PLAYER_HEAD) || damager.getInventory().getItemInMainHand().getType().equals((Object)Material.WITHER_SKELETON_SKULL) || damager.getInventory().getItemInOffHand().getType().equals((Object)Material.WITHER_SKELETON_SKULL))) {
            ItemStack heads;
            damagee.sendMessage(damager.getName() + " has revived you!");
            damager.sendMessage("You have revived " + damagee.getName());
            for (PotionEffect effect : damagee.getActivePotionEffects()) {
                damagee.removePotionEffect(effect.getType());
            }
            damagee.setHealth(10.0);
            damagee.setWalkSpeed(0.2f);
            damagee.setGlowing(false);
            downedDamagee.cancel();
            this.downedPlayers.remove(damagee.getUniqueId());
            if (damager.getInventory().getItemInMainHand().getType().equals((Object)Material.PLAYER_HEAD)) {
                heads = new ItemStack(Material.PLAYER_HEAD, damager.getInventory().getItemInMainHand().getAmount() - 1);
                damager.getInventory().setItemInMainHand(heads);
            }
            if (damager.getInventory().getItemInMainHand().getType().equals((Object)Material.WITHER_SKELETON_SKULL)) {
                heads = new ItemStack(Material.WITHER_SKELETON_SKULL, damager.getInventory().getItemInMainHand().getAmount() - 1);
                damager.getInventory().setItemInMainHand(heads);
            }
            if (damager.getInventory().getItemInOffHand().getType().equals((Object)Material.PLAYER_HEAD)) {
                heads = new ItemStack(Material.PLAYER_HEAD, damager.getInventory().getItemInOffHand().getAmount() - 1);
                damager.getInventory().setItemInOffHand(heads);
            }
            if (damager.getInventory().getItemInOffHand().getType().equals((Object)Material.WITHER_SKELETON_SKULL)) {
                heads = new ItemStack(Material.WITHER_SKELETON_SKULL, damager.getInventory().getItemInOffHand().getAmount() - 1);
                damager.getInventory().setItemInOffHand(heads);
            }
            e.setCancelled(true);
            return;
        }
        if (!this.db.selectZonePVP(damagee.getLocation().getBlockX(), damagee.getLocation().getBlockY(), damagee.getLocation().getBlockZ(), damagee.getLocation().getWorld().toString())) {
            e.setCancelled(true);
            return;
        }
    }

    public void playerOnEntityDamage(EntityDamageByEntityEvent e) {
        try {
            Player damager = (Player)e.getDamager();
            BukkitTask downedDamager = this.downedPlayers.get(damager.getUniqueId());
            if (downedDamager != null) {
                e.setCancelled(true);
                return;
            }
        }
        catch (Exception er) {
            this.plugin.getLogger().info("BAD TOUCH IN PLAYER_ON_ENTITY_DAMAGE");
        }
    }

    public void entityOnPlayerDamage(EntityDamageByEntityEvent e) {
        Player damagee = (Player)e.getEntity();
        if (this.isPlayerDown(damagee)) {
            e.setCancelled(true);
            return;
        }
        if (this.isPlayerOnTeam(damagee)) {
            this.updateTeamBoard(damagee);
        }
    }

    public void setPlayerAsDown(Player player) {
        player.setHealth(20.0);
        player.setWalkSpeed(0.0f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 10000, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 10000, 250));
        player.setGlowing(true);
        player.setSneaking(true);
        this.downedPlayerScheduler(player);
        if (this.isPlayerOnTeam(player)) {
            MSTeam team = this.teams.getTeam(player);
            this.board.setScoreboard(team.getMembersPlayerObjects(), this.teams.getTeam(player).getName(), player, (int)(player.getHealth() * -1.0));
            this.teams.alertTeamOfDowns(team.getName(), player);
        }
    }

    private void downedPlayerScheduler(Player player) {
        this.downedPlayers.put(player.getUniqueId(), Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            try {
                if (player.getHealth() - 1.0 <= 0.0) {
                    this.downedPlayers.get(player.getUniqueId()).cancel();
                    this.downedPlayers.remove(player.getUniqueId());
                    player.setHealth(0.0);
                } else {
                    player.setHealth(player.getHealth() - 1.0);
                }
                this.updateTeamBoard(player);
            }
            catch (NullPointerException np) {
                this.plugin.getLogger().info("Damagee or other element is null, likely due to disconnecting. " + np.toString());
                this.downedPlayers.get(player.getUniqueId()).cancel();
                this.downedPlayers.remove(player.getUniqueId());
                player.setHealth(0.0);
            }
            catch (Exception err) {
                this.plugin.getLogger().info("Error on slowly killing person. " + err.toString());
            }
        }, 10L, 35L));
    }
}

