/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.Database;
import com.mineswarm.EventListenerHelper;
import com.mineswarm.Kits;
import com.mineswarm.MSPlayer;
import com.mineswarm.MakePotion;
import com.mineswarm.MineswarmTeams;
import com.mineswarm.PotionObjects;
import com.mineswarm.TeamBoards;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.Trident;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Openable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class EventListener
implements Listener {
    public Plugin plugin;
    public Database db = null;
    private boolean debugging = true;
    private PotionObjects potions = null;
    private MineswarmTeams teams = null;
    private EventListenerHelper helper = null;
    private Kits kits;
    HashMap<UUID, BukkitTask> downedPlayers = new HashMap();
    private HashMap<UUID, MSPlayer> msplayers;

    public EventListener(Plugin instance, MineswarmTeams teams, TeamBoards board, PotionObjects potions, HashMap<UUID, MSPlayer> msplayers, Kits kits) {
        this.plugin = instance;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.debugging = this.plugin.getConfig().getBoolean("debugging");
        this.db = new Database(this.plugin);
        this.teams = teams;
        this.potions = potions;
        this.msplayers = msplayers;
        this.kits = kits;
        this.helper = new EventListenerHelper(board, teams, this.db, this.msplayers, this.downedPlayers, this.plugin);
        board.setTeamData(this.helper, teams);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerID = player.getUniqueId();
        if (this.msplayers.get(playerID) == null) {
            this.msplayers.put(playerID, new MSPlayer(player.getName(), playerID));
        } else {
            player.setHealth(0.0);
            this.helper.updateTeamBoard(player);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        final Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                EventListener.this.helper.updateTeamBoard(player);
                player.getInventory().clear();
            }
        }, 5L);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        event.getDrops().clear();
        Player player = event.getEntity();
        PlayerInventory inv = player.getInventory();
        inv.clear();
        inv.setArmorContents(new ItemStack[4]);
        inv.getItemInOffHand().setAmount(0);
        inv.getItemInMainHand().setAmount(0);
        inv.setExtraContents(new ItemStack[inv.getExtraContents().length]);
        this.helper.clearPlayerFromTPQue(player);
        this.helper.resetPlayerFromLastStand(player);
        this.helper.updateTeamBoard(player);
        this.msplayers.get(player.getUniqueId()).setItemClass(null);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void allDamageEvent(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player) {
            this.helper.enviormentalOnPlayerDamage(e);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        Player player;
        Projectile projetile;
        if (e.getDamager() instanceof Player && e.getEntity() instanceof Player) {
            this.helper.playerOnPlayerDamage(e);
        } else if (e.getDamager() instanceof Player && !(e.getEntity() instanceof Player)) {
            this.helper.playerOnEntityDamage(e);
        } else if (!(e.getDamager() instanceof Player) && e.getEntity() instanceof Player) {
            this.helper.entityOnPlayerDamage(e);
        }
        if ((e.getDamager() instanceof Trident || e.getDamager() instanceof Arrow || e.getDamager() instanceof Projectile || e.getDamager() instanceof PotionEffect) && (projetile = (Projectile)e.getDamager()).getShooter() instanceof Player) {
            if (this.downedPlayers.get(((Player)projetile.getShooter()).getUniqueId()) != null) {
                e.setCancelled(true);
                return;
            }
            if (e.getEntity() instanceof Player) {
                if (this.downedPlayers.get(((Player)e.getEntity()).getUniqueId()) != null) {
                    e.setCancelled(true);
                    return;
                }
                Player damagee = (Player)e.getEntity();
                if (!this.db.selectZonePVP(damagee.getLocation().getBlockX(), damagee.getLocation().getBlockY(), damagee.getLocation().getBlockZ(), damagee.getLocation().getWorld().toString())) {
                    e.setCancelled(true);
                    return;
                }
            }
        }
        if (!e.isCancelled() && e.getEntity() instanceof Player && (player = (Player)e.getEntity()).getHealth() - e.getFinalDamage() <= 0.5) {
            e.setCancelled(true);
            this.helper.setPlayerAsDown(player);
            this.helper.updateTeamBoard(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void OnEntityExplodeEvent(EntityExplodeEvent event) {
        if (this.plugin.getConfig().getBoolean("disable-all-explosions")) {
            event.blockList().clear();
            return;
        }
        EntityType ent = event.getEntityType();
        if (this.plugin.getConfig().getBoolean("disable-creeper-explosions") && ent.equals((Object)EntityType.CREEPER)) {
            event.blockList().clear();
            return;
        }
        if (this.plugin.getConfig().getBoolean("disable-dragon-explosions") && ent.equals((Object)EntityType.ENDER_DRAGON)) {
            event.blockList().clear();
            return;
        }
        if (this.plugin.getConfig().getBoolean("disable-tnt-explosions") && ent.equals((Object)EntityType.TNT_MINECART)) {
            event.blockList().clear();
            return;
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (e.getTo().getBlockX() == e.getFrom().getBlockX() && e.getTo().getBlockY() == e.getFrom().getBlockY() && e.getTo().getBlockZ() == e.getFrom().getBlockZ()) {
            return;
        }
        if (this.teams.tpQueue.containsKey(e.getPlayer().getUniqueId())) {
            this.teams.tpQueue.get(e.getPlayer().getUniqueId()).cancel();
            this.teams.tpQueue.remove(e.getPlayer().getUniqueId());
            e.getPlayer().sendMessage("TP has been cancelled due to movement");
            return;
        }
    }

    @EventHandler
    public void onEDeath(EntityDeathEvent event) {
        block21: {
            if (event.getEntity() instanceof Player) {
                return;
            }
            boolean cfr_ignored_0 = event.getEntity().getKiller() instanceof Player;
            Player killer = event.getEntity().getKiller();
            if (killer != null && (killer instanceof Player || killer instanceof Arrow || killer instanceof Trident || killer instanceof SplashPotion || killer instanceof PotionEffect)) {
                Random rand;
                List mobConfig;
                if (killer instanceof PotionEffect) {
                    this.plugin.getLogger().info("POTION EFFECT WORKS!");
                }
                Player player = event.getEntity().getKiller();
                if (this.debugging) {
                    player.sendMessage(event.getEntity().getType().toString());
                }
                if ((mobConfig = this.plugin.getConfig().getStringList("key-dropping-mobs")).indexOf(event.getEntity().getType().toString()) != -1 && ((rand = new Random()).nextInt(Integer.valueOf((String)mobConfig.get(mobConfig.indexOf(event.getEntity().getType().toString()) + 1))) + 1 == 1 || this.debugging)) {
                    try {
                        ItemStack book_drop = new ItemStack(Material.BOOK, 1);
                        try {
                            int x = event.getEntity().getLocation().getBlockX();
                            int y = event.getEntity().getLocation().getBlockY();
                            int z = event.getEntity().getLocation().getBlockZ();
                            String world = event.getEntity().getLocation().getWorld().toString();
                            String keyinfo = "";
                            try {
                                keyinfo = this.db.selectZoneLevel(x, y, z, world);
                            }
                            catch (Exception ers) {
                                this.plugin.getLogger().info(ers.toString());
                            }
                            ArrayList<String> lore = new ArrayList<String>();
                            lore.add(keyinfo);
                            ItemMeta meta = book_drop.getItemMeta();
                            meta.setDisplayName("Key");
                            if (meta.hasLore()) {
                                meta.getLore().add(keyinfo);
                            } else {
                                meta.setLore(lore);
                            }
                            book_drop.setItemMeta(meta);
                        }
                        catch (Exception er) {
                            this.plugin.getLogger().info("Problem with setting custom name or lore in MOBKEYS: " + er.toString());
                        }
                        if (this.plugin.getConfig().getString("keys-drop-to") == "player") {
                            player.getLocation().getWorld().dropItem(player.getLocation(), book_drop);
                        } else {
                            event.getEntity().getLocation().getWorld().dropItem(player.getLocation(), book_drop);
                        }
                    }
                    catch (Exception er) {
                        this.plugin.getLogger().info("Problem with drops: " + er.toString());
                    }
                }
                try {
                    if (!this.plugin.getConfig().getStringList("item-dropping-mobs").contains(event.getEntity().getType().toString().toUpperCase())) break block21;
                    List configElement = this.plugin.getConfig().getStringList("mob-drops");
                    int i = 0;
                    while (i < configElement.size()) {
                        Material item = Material.matchMaterial((String)((String)configElement.get(i)));
                        Random rand2 = new Random();
                        if (rand2.nextInt(Integer.valueOf((String)configElement.get(i + 1))) + 1 == 1 || this.debugging) {
                            ItemStack item_drop = new ItemStack(item, Integer.valueOf((String)configElement.get(i + 2)).intValue());
                            if (this.plugin.getConfig().getString("items-drop-to") == "player") {
                                player.getLocation().getWorld().dropItem(player.getLocation(), item_drop);
                            } else {
                                event.getEntity().getLocation().getWorld().dropItem(player.getLocation(), item_drop);
                            }
                            break;
                        }
                        i += 3;
                    }
                }
                catch (Exception er) {
                    this.plugin.getLogger().info("Problem with random item drop: " + er.toString());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void keyDropAlert(ItemSpawnEvent e) {
        ItemStack item = e.getEntity().getItemStack();
        if (item.getType().equals((Object)Material.BOOK) && item.hasItemMeta() && item.getItemMeta().getDisplayName().equals("Key")) {
            for (Entity ent : e.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                Player player;
                if (!(ent instanceof Player) || (player = (Player)ent).getInventory().firstEmpty() != -1) continue;
                PlayerInventory invt = player.getInventory();
                boolean inInventory = false;
                for (ItemStack is : invt) {
                    if (is == null || !is.getType().equals((Object)Material.BOOK) || !is.hasItemMeta() || !((String)is.getItemMeta().getLore().get(0)).equals(item.getItemMeta().getLore().get(0))) continue;
                    inInventory = true;
                    break;
                }
                if (inInventory) continue;
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + "You are near a " + (String)item.getItemMeta().getLore().get(0) + " Key but don't have room to pick it up.");
                if (this.teams.getTeam(player) == null) continue;
                this.teams.sendTeamMessage(player.getName() + " Is near a " + (String)item.getItemMeta().getLore().get(0) + " Key but can't pick it up.", player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PickupItem(EntityPickupItemEvent e) {
        ItemStack pickedUp = e.getItem().getItemStack();
        if (pickedUp.getType().equals((Object)Material.BOOK) && pickedUp.hasItemMeta() && pickedUp.getItemMeta().getDisplayName().equals("Key") && e.getEntity() instanceof Player) {
            Player player = (Player)e.getEntity();
            player.sendMessage(String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "You picked up a " + (String)pickedUp.getItemMeta().getLore().get(0) + " Key");
            if (this.teams.getTeam(player) != null) {
                this.teams.sendTeamMessage(player.getName() + " Picked up a " + (String)pickedUp.getItemMeta().getLore().get(0) + " Key", player);
            }
        }
    }

    public Inventory getClickedInventory(InventoryView view, int slot) {
        try {
            Inventory clickedInventory = slot < 0 ? null : (view.getTopInventory() != null && slot < view.getTopInventory().getSize() ? view.getTopInventory() : view.getBottomInventory());
            return clickedInventory;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerClick(InventoryClickEvent event) {
        if (event.getInventory().getType().equals((Object)InventoryType.CRAFTING) && event.getSlot() >= -1) {
            return;
        }
        if (event.getSlot() < 0) {
            event.setCancelled(true);
            return;
        }
        try {
            if (event.getInventory().getType().equals((Object)InventoryType.ANVIL)) {
                InventoryHolder ih = event.getInventory().getHolder();
                Block block = (Block)ih;
                if (this.debugging) {
                    this.plugin.getLogger().info("Reparing Anvil on use...");
                }
                block.setType(Material.ANVIL);
            }
            if (!event.getWhoClicked().getGameMode().equals((Object)GameMode.CREATIVE)) {
                List allowedItems = this.plugin.getConfig().getStringList("dropping-whitelist");
                String currentItem = event.getCurrentItem().getType().toString().replace(" ", "_").toUpperCase();
                switch (event.getInventory().getType()) {
                    case BARREL: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case BEACON: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case BLAST_FURNACE: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case BREWING: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case CARTOGRAPHY: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case DISPENSER: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case DROPPER: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case GRINDSTONE: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case HOPPER: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case LECTERN: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case LOOM: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case STONECUTTER: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                        break;
                    }
                    case SMOKER: {
                        if (allowedItems.contains(currentItem)) break;
                        event.setCancelled(true);
                    }
                }
                if (this.getClickedInventory(event.getView(), event.getRawSlot()).getType().equals((Object)InventoryType.CHEST)) {
                    if (!event.isShiftClick()) {
                        if (event.isLeftClick()) {
                            event.setCancelled(true);
                            return;
                        }
                        if (event.isRightClick()) {
                            event.setCancelled(true);
                            return;
                        }
                    }
                } else {
                    if (event.isShiftClick() && !allowedItems.contains(currentItem)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (event.isLeftClick() && event.isShiftClick() && !allowedItems.contains(currentItem)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (event.isRightClick() && event.isShiftClick() && !allowedItems.contains(currentItem)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
            try {
                if (event.getClick().isRightClick() && (event.getAction().equals((Object)InventoryAction.DROP_ONE_CURSOR) || event.getAction().equals((Object)InventoryAction.DROP_ALL_CURSOR))) {
                    event.getWhoClicked().getInventory().remove(event.getCurrentItem());
                    if (this.plugin.getConfig().getBoolean("debugging")) {
                        this.plugin.getLogger().info(event.getCurrentItem().getType().toString().replace(" ", "_").toUpperCase());
                    }
                    if (this.plugin.getConfig().getStringList("dropping-whitelist").contains(event.getCurrentItem().getType().toString().replace(" ", "_").toUpperCase())) {
                        event.setCancelled(false);
                        return;
                    }
                    event.setCancelled(true);
                }
            }
            catch (Exception err) {
                if (this.plugin.getConfig().getBoolean("debugging")) {
                    this.plugin.getLogger().info("Minor bump in inventory watching (RC) " + err.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (this.plugin.getConfig().getBoolean("debugging")) {
            this.plugin.getLogger().info(event.getItemDrop().getName().toString().replace(" ", "_").toUpperCase());
        }
        if (this.plugin.getConfig().getStringList("dropping-whitelist").contains(event.getItemDrop().getName().toString().replace(" ", "_").toUpperCase())) {
            event.setCancelled(false);
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void PotionSplashEvent(PotionSplashEvent event) {
        try {
            if (event.getPotion().getShooter() instanceof Player) {
                boolean effectPlayer = true;
                boolean effectMob = true;
                String playerClass = "default";
                Player shooter = (Player)event.getPotion().getShooter();
                if (this.downedPlayers.get(shooter.getUniqueId()) != null) {
                    event.setCancelled(true);
                    return;
                }
                ArrayList<PotionEffectType> effectTypes = new ArrayList<PotionEffectType>();
                for (PotionEffect effect : event.getPotion().getEffects()) {
                    effectTypes.add(effect.getType());
                }
                final MakePotion potion = this.potions.getPotionByEffects(effectTypes);
                String potionName = potion.name;
                for (String configPotion : this.plugin.getConfig().getStringList(playerClass + "-potions-disabled-players")) {
                    if (!configPotion.equals(potionName)) continue;
                    effectPlayer = false;
                    break;
                }
                for (String configPotion : this.plugin.getConfig().getStringList(playerClass + "-potions-disabled-mobs")) {
                    if (!potionName.equals(configPotion)) continue;
                    effectMob = false;
                    break;
                }
                for (final Entity ent : event.getAffectedEntities()) {
                    if (ent instanceof Player && effectPlayer) {
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                Player mob = (Player)ent;
                                for (PotionEffectType ef : potion.effectTypes) {
                                    mob.addPotionEffect(new PotionEffect(ef, (int)potion.duration, potion.amplifier));
                                }
                            }
                        }, 1L);
                    }
                    if (!(ent instanceof LivingEntity) || !effectMob || ent instanceof Player) continue;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            LivingEntity mob = (LivingEntity)ent;
                            for (PotionEffectType ef : potion.effectTypes) {
                                mob.addPotionEffect(new PotionEffect(ef, (int)potion.duration, potion.amplifier), true);
                            }
                        }
                    }, 1L);
                }
                event.setCancelled(true);
            }
        }
        catch (Exception er) {
            this.plugin.getLogger().info("Error with potion blocking: " + er.toString());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onHealthRegen(EntityRegainHealthEvent event) {
        if (event.getEntityType().equals((Object)EntityType.PLAYER)) {
            Player player = (Player)event.getEntity();
            this.helper.updateTeamBoard(player, (int)Math.round(event.getAmount() + player.getHealth()));
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent e) {
        Entity[] entityArray = e.getChunk().getEntities();
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity mob = entityArray[n2];
            mob.remove();
            ++n2;
        }
    }

    /*
     * Exception decompiling
     */
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void scheduleDoorClose(final Block block, final PlayerInteractEvent event) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                BlockState state = block.getState();
                try {
                    state = event.getClickedBlock().getRelative(BlockFace.DOWN).getState();
                    Openable door = (Openable)state.getData();
                    door.setOpen(false);
                    state.setData((MaterialData)((Door)door));
                    state.update();
                }
                catch (Exception err) {
                    state = event.getClickedBlock().getState();
                    Openable door = (Openable)state.getData();
                    door.setOpen(false);
                    state.setData((MaterialData)((Door)door));
                    state.update();
                }
            }
        }, 55L);
    }

    void openDoor(Block block, PlayerInteractEvent event) {
        BlockState state = block.getState();
        try {
            state = block.getRelative(BlockFace.DOWN).getState();
            Openable door = (Openable)state.getData();
            door.setOpen(true);
            state.setData((MaterialData)((Door)door));
            state.update();
        }
        catch (Exception err) {
            state = event.getClickedBlock().getState();
            Openable door = (Openable)state.getData();
            door.setOpen(true);
            state.setData((MaterialData)((Door)door));
            state.update();
        }
        event.setCancelled(true);
    }
}

