/*
 * Decompiled with CFR 0.152.
 */
package com.mineswarm;

import com.mineswarm.MakePotion;
import com.mineswarm.PotionObjects;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Database {
    public Plugin plugin;

    public Database(Plugin instance) {
        this.plugin = instance;
    }

    public Connection connect() {
        return this.establishDatabaseConnection();
    }

    private Connection establishDatabaseConnection() {
        return this.establishDatabaseConnection("mineswarm");
    }

    private Connection establishDatabaseConnection(String database) {
        Connection conn;
        block3: {
            try {
                String url = String.format("jdbc:sqlite:plugins/Mineswarm/%s.db", database);
                conn = DriverManager.getConnection(url);
                if (conn != null) break block3;
                this.plugin.getLogger().warning(String.format("Failure to establish database connection to: %s ", database));
                return null;
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning(e.getMessage());
                return null;
            }
        }
        return conn;
    }

    private static void close(Connection conn) throws SQLException {
        if (conn != null) {
            conn.close();
        }
    }

    public static void closeQuietly(Connection conn) {
        try {
            Database.close(conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closePreparedStatement(PreparedStatement prep) throws SQLException {
        if (prep != null) {
            prep.close();
        }
    }

    public static void closePreparedStatementQuietly(PreparedStatement prep) {
        try {
            Database.closePreparedStatement(prep);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeResultSet(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    public static void closeResultSetQuietly(ResultSet rs) {
        try {
            Database.closeResultSet(rs);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setupDatabases() {
        this.createTable();
    }

    private void createTable() {
        block6: {
            Connection conn = this.establishDatabaseConnection("mineswarm");
            if (conn == null) {
                return;
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS zones(id,min_x,min_y,min_z,max_x,max_y,max_z,level,creator,world,pvp_enabled,mob_multiplier)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Zones Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS doors(id, level, block_y,creator)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Doors Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS buttons(x,y,z,world,class)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Buttons Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS players(name, total_damage_taken, total_damage_delt, kit, has_died, isdown, first_joined, team_name, team_size, deaths, players_saved, downs, been_revived, start_time, end_time, mobs_killed)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Players Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS chests(x,y,z,world,creator,items)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Chests Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS teams (name TEXT, owner TEXT, closed INTEGER, score INTEGER)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Teams Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS members(team_id INTEGER, member TEXT)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Members Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS spawners(location,world,etype,max_mobs,chance,weapons,durability,enchantments, effects)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Spawners Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS solo_scores(name, total_damage_taken, total_damage_delt, kit, first_joined, team_name, team_size, deaths, players_saved, downs, been_revived, start_time, end_time, run_time, mobs_killed, team_members)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Solo Scores Setup...");
                    pstmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS team_scores(total_damage_taken, total_damage_delt, team_name, team_size, deaths, players_saved, downs, been_revived, start_time, end_time, run_time, mobs_killed, team_members)");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    this.plugin.getLogger().info("    Team Scores Setup...");
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(e.getMessage());
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void emptyTeamsTable() {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("DELETE FROM teams");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                    pstmt = conn.prepareStatement("DELETE FROM members");
                    pstmt.execute();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error emptying teams table, error: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public HashMap<String, List<UUID>> getTeams() {
        HashMap<String, List<UUID>> newData;
        block8: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            newData = new HashMap<String, List<UUID>>();
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM teams");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<UUID> ids = new ArrayList<UUID>();
                        for (String val : Arrays.asList(rs.getString("data").split("\\s*,\\s*"))) {
                            ids.add(UUID.fromString(val));
                        }
                        newData.put(rs.getString("key"), ids);
                    }
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error selecting teams, error: %s", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return newData;
    }

    public HashMap<Location, String> getButtons() {
        HashMap<Location, String> newData;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            newData = new HashMap<Location, String>();
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM buttons");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        newData.put(new Location(Bukkit.getWorld((String)rs.getString("world")), (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")), rs.getString("class"));
                    }
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error retrieving button data, error: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return newData;
    }

    public void saveButton(Location location, String name) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            String sql = "INSERT INTO buttons(x,y,z,world,class) VALUES(?,?,?,?,?)";
            try {
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, (int)location.getX());
                    pstmt.setInt(2, (int)location.getY());
                    pstmt.setInt(3, (int)location.getZ());
                    pstmt.setString(4, location.getWorld().getName());
                    pstmt.setString(5, name);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error inserting button data in table, error: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public boolean getScores(int topScores) {
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM scores ORDER BY run_time DESC LIMIT ?");
                    pstmt.setInt(1, topScores);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                    }
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error retrieving score data, error: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return true;
    }

    public String getDoorByLocation(String location, int y) {
        String level;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            level = null;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT level, block_y FROM doors WHERE id = ?");
                    pstmt.setString(1, location);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int db_y = rs.getInt("block_y");
                        if (db_y - 1 != y && db_y + 1 != y && db_y != y) continue;
                        level = rs.getString("level");
                    }
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error retrieving door data from table: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return level;
    }

    public void makeDoor(String location, int y, String level, String creator) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO doors(id,level,block_y,creator) VALUES(?,?,?,?)");
                    pstmt.setString(1, location);
                    pstmt.setString(2, level);
                    pstmt.setInt(3, y);
                    pstmt.setString(4, creator);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error inserting door data: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void destroyDoor(String location, int y) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("DELETE FROM doors WHERE id = ? AND (block_y-1 = ? OR block_y+1 = ? OR block_y = ?)");
                    pstmt.setString(1, location);
                    pstmt.setInt(2, y);
                    pstmt.setInt(3, y);
                    pstmt.setInt(4, y);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error deleting door data: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void deleteDoor(String location, int y, String creator) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("DELETE FROM doors WHERE id = ? AND creator = ? AND (block_y-1 = ? OR block_y+1 = ? OR block_y = ?) ");
                    pstmt.setString(1, location);
                    pstmt.setString(2, creator);
                    pstmt.setInt(3, y);
                    pstmt.setInt(4, y);
                    pstmt.setInt(5, y);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error deleting door data: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void makeZone(String id, int min_x, int min_y, int min_z, int max_x, int max_y, int max_z, String level, String creator, String world, boolean pvp_enabled, int mob_multiplier) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO zones(id, min_x, min_y, min_z, max_x, max_y, max_z, level, creator, world, pvp_enabled, mob_multiplier) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
                    pstmt.setString(1, id);
                    pstmt.setInt(2, min_x);
                    pstmt.setInt(3, min_y);
                    pstmt.setInt(4, min_z);
                    pstmt.setInt(5, max_x);
                    pstmt.setInt(6, max_y);
                    pstmt.setInt(7, max_z);
                    pstmt.setString(8, level);
                    pstmt.setString(9, creator);
                    pstmt.setString(10, world);
                    pstmt.setBoolean(11, pvp_enabled);
                    pstmt.setInt(12, mob_multiplier);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error making zone data: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public String selectZoneLevel(int x, int y, int z, String world) {
        String results;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            results = "Generic";
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT level FROM zones WHERE min_x < ? AND min_z < ? AND min_y < ? AND max_y > ? AND max_x > ? AND max_z > ? AND world = ? LIMIT 1");
                    pstmt.setInt(1, x);
                    pstmt.setInt(2, z);
                    pstmt.setInt(3, y);
                    pstmt.setInt(4, y);
                    pstmt.setInt(5, x);
                    pstmt.setInt(6, z);
                    pstmt.setString(7, world);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        results = rs.getString("level");
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error selecting zone data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return results;
    }

    public boolean selectZonePVP(int x, int y, int z, String world) {
        Boolean results;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            results = this.plugin.getConfig().getBoolean("default-pvp-on");
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT pvp_enabled FROM zones WHERE min_x < ? AND min_z < ? AND min_y < ? AND max_y > ? AND max_x > ? AND max_z > ? AND world = ? LIMIT 1");
                    pstmt.setInt(1, x);
                    pstmt.setInt(2, z);
                    pstmt.setInt(3, y);
                    pstmt.setInt(4, y);
                    pstmt.setInt(5, x);
                    pstmt.setInt(6, z);
                    pstmt.setString(7, world);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        results = rs.getBoolean("pvp_enabled");
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error selecting zone's PVP data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return results;
    }

    public List<String> showZone(int x, int y, int z, String world) {
        ArrayList<String> data;
        block8: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            data = null;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM zones WHERE min_x < ? AND min_z < ? AND min_y < ? AND max_y > ? AND max_x > ? AND max_z > ? AND world = ? LIMIT 1");
                    pstmt.setInt(1, x);
                    pstmt.setInt(2, z);
                    pstmt.setInt(3, y);
                    pstmt.setInt(4, y);
                    pstmt.setInt(5, x);
                    pstmt.setInt(6, z);
                    pstmt.setString(7, world);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        data = new ArrayList<String>();
                        data.add("Starting points: X: " + rs.getString("min_x") + " Y: " + rs.getString("min_y") + " Z: " + rs.getString("min_z"));
                        data.add("Ending points: X: " + rs.getString("max_x") + " Y: " + rs.getString("max_y") + " Z: " + rs.getString("max_z"));
                        data.add("World: " + rs.getString("world"));
                        data.add("PVP Enabled: " + rs.getString("pvp_enabled"));
                        data.add("Mob health multiplier: " + rs.getString("mob_multiplier"));
                        data.add("Created by: " + rs.getString("creator"));
                        data.add("Level: " + rs.getString("level"));
                        data.add("Name/ID: " + rs.getString("id"));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error selecting zone's PVP data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        if (data.size() <= 0) {
            data.add("No zone found.");
        }
        return data;
    }

    public List<String> tpToZone(String name) {
        ArrayList<String> data;
        block8: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            data = null;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM zones WHERE id = ? OR level = ? LIMIT 1");
                    pstmt.setString(1, name);
                    pstmt.setString(2, name);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int x = (Integer.valueOf(rs.getString("min_x")) + Integer.valueOf(rs.getString("max_x"))) / 2;
                        int y = (Integer.valueOf(rs.getString("min_y")) + Integer.valueOf(rs.getString("max_y"))) / 2;
                        int z = (Integer.valueOf(rs.getString("min_z")) + Integer.valueOf(rs.getString("max_z"))) / 2;
                        String world = rs.getString("world").replace("CraftWorld{name=", "").replace("}", "");
                        data = new ArrayList<String>();
                        data.add(world);
                        data.add(String.valueOf(x));
                        data.add(String.valueOf(y));
                        data.add(String.valueOf(z));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error finding TP Zone data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        if (data.size() <= 0) {
            data.add("No zone found.");
        }
        return data;
    }

    public List<String> getMobSpawners() {
        ArrayList<String> data;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            data = null;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM spawners");
                    rs = pstmt.executeQuery();
                    data = new ArrayList<String>();
                    while (rs.next()) {
                        data.add(rs.getString("location"));
                        data.add(rs.getString("world"));
                        data.add(rs.getString("etype"));
                        data.add(rs.getString("max_mobs"));
                        data.add(rs.getString("chance"));
                        data.add(rs.getString("weapons"));
                        data.add(rs.getString("durability"));
                        data.add(rs.getString("enchantments"));
                        data.add(rs.getString("effects"));
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error selecting mob spawner data: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return data;
    }

    public void makeSpawner(String location, String world, String mobType, int maxMobs, String weapon, int chance, int durability, List<String> enchantments, List<String> effects) {
        block10: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO spawners(location,world,etype,max_mobs,chance,weapons,durability,enchantments,effects) VALUES(?,?,?,?,?,?,?,?,?)");
                    if (enchantments == null || enchantments.isEmpty()) {
                        pstmt.setString(8, "NONE");
                    } else {
                        pstmt.setString(8, String.join((CharSequence)",", enchantments));
                    }
                    if (effects == null || effects.isEmpty()) {
                        pstmt.setString(9, "NONE");
                    } else {
                        pstmt.setString(9, String.join((CharSequence)",", effects));
                    }
                    pstmt.setString(1, location);
                    pstmt.setString(2, world);
                    pstmt.setString(3, mobType);
                    pstmt.setInt(4, maxMobs);
                    pstmt.setInt(5, chance);
                    pstmt.setString(6, weapon);
                    pstmt.setInt(7, durability);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error creating mob spawner: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void createChest(int x, int y, int z, String world, String creator, String items) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO chests(x,y,z,world,creator,items) VALUES(?,?,?,?,?,?)");
                    pstmt.setInt(1, x);
                    pstmt.setInt(2, y);
                    pstmt.setInt(3, z);
                    pstmt.setString(4, world);
                    pstmt.setString(5, creator);
                    pstmt.setString(6, items);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error creating chest: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void getChests(PotionObjects potions) {
        block21: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = conn.prepareStatement("SELECT * FROM chests");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    try {
                        Chest chest = (Chest)new Location(Bukkit.getWorld((String)rs.getString("world")), (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")).getBlock().getState();
                        List<String> items = Arrays.asList(rs.getString("items").split("\\s*,\\s*"));
                        ItemStack[] contents = new ItemStack[items.size() / 2];
                        int j = 0;
                        int i = 0;
                        while (i < items.size()) {
                            ItemStack toAdd = null;
                            try {
                                int pID = Integer.valueOf(items.get(i).toString());
                                MakePotion potionData = potions.getDrinkableDataById(pID);
                                toAdd = potionData.isSplash ? new ItemStack(Material.SPLASH_POTION, Integer.valueOf(items.get(i + 1).toString()).intValue()) : new ItemStack(Material.POTION, Integer.valueOf(items.get(i + 1).toString()).intValue());
                                try {
                                    ItemMeta im = toAdd.getItemMeta();
                                    im.setDisplayName(potionData.name);
                                    PotionMeta pm = (PotionMeta)im;
                                    for (PotionEffectType effect : potionData.effectTypes) {
                                        pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                                    }
                                    pm.setColor(potionData.color);
                                    toAdd.setItemMeta(im);
                                }
                                catch (Exception err) {
                                    this.plugin.getLogger().info("ERROR : " + err.toString());
                                }
                            }
                            catch (NumberFormatException nf) {
                                try {
                                    int pID = Integer.valueOf(items.get(i).toString().replaceAll("TIPPED_ARROW:", ""));
                                    MakePotion potionData = potions.getDrinkableDataById(pID);
                                    if (items.get(i).toUpperCase().contains("TIPPED_ARROW:")) {
                                        toAdd = new ItemStack(Material.TIPPED_ARROW, Integer.valueOf(items.get(i + 1)).intValue());
                                        ItemMeta im = toAdd.getItemMeta();
                                        PotionMeta pm = (PotionMeta)im;
                                        im.setDisplayName(potionData.name);
                                        for (PotionEffectType effect : potionData.effectTypes) {
                                            pm.addCustomEffect(new PotionEffect(effect, (int)potionData.duration, potionData.amplifier), true);
                                        }
                                        pm.setColor(potionData.color);
                                        toAdd.setItemMeta(im);
                                    }
                                }
                                catch (NumberFormatException nfe) {
                                    toAdd = new ItemStack(Material.getMaterial((String)items.get(i).toString()), Integer.valueOf(items.get(i + 1)).intValue());
                                }
                            }
                            if (toAdd != null) {
                                contents[j] = toAdd;
                            }
                            ++j;
                            i += 2;
                        }
                        chest.getBlockInventory().setContents(contents);
                    }
                    catch (Exception err) {
                        this.plugin.getLogger().info("Failed to cast block: " + err.toString());
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().warning(String.format("Error getting chest data: ", e.getMessage()));
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                break block21;
            }
            catch (Exception e) {
                try {
                    this.plugin.getLogger().warning(String.format("Error unrelated to SQL while getting chest data: ", e.getMessage()));
                }
                catch (Throwable throwable) {
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    throw throwable;
                }
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                break block21;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public boolean playerExists(String name) {
        Boolean exists;
        block7: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            exists = false;
            try {
                try {
                    pstmt = conn.prepareStatement("SELECT * FROM players WHERE name = ?");
                    pstmt.setString(1, name);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        exists = true;
                    }
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error getting player existence: ", e.getMessage()));
                    Database.closeResultSetQuietly(rs);
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Database.closeResultSetQuietly(rs);
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closeResultSetQuietly(rs);
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return exists;
    }

    public void deleteChest(int x, int y, int z, String world, String creator) {
    }

    public void destroyChest(int x, int y, int z, String world) {
    }

    public int updateTeamsTable(String name, String string, boolean closed, int score) {
        int result;
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            result = -1;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO teams(name, owner, closed, score) VALUES(?,?,?,?)");
                    pstmt.setString(1, name);
                    pstmt.setString(2, string);
                    pstmt.setBoolean(3, closed);
                    pstmt.setInt(4, score);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                    pstmt = conn.prepareStatement("SELECT last_insert_rowid() AS LAST_ID");
                    result = Integer.parseInt(pstmt.executeQuery().getString("LAST_ID"));
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error updating teams table, error: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return result;
    }

    public int updateOpenTeams(String teamName, boolean closed, int score) {
        int result;
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            result = -1;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO teams(name, closed, score) VALUES(?,?,?)");
                    pstmt.setString(1, teamName);
                    pstmt.setBoolean(2, closed);
                    pstmt.setInt(3, score);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                    pstmt = conn.prepareStatement("SELECT last_insert_rowid() AS LAST_ID");
                    result = Integer.parseInt(pstmt.executeQuery().getString("LAST_ID"));
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error updating teams table, error: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
        return result;
    }

    public void insertMembers(String member, int teamID) {
        block6: {
            Connection conn = this.establishDatabaseConnection();
            if (conn == null) {
                this.plugin.getLogger().warning("Connection to Database Failed, returned null.");
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO members(member, team_id) VALUES(?,?)");
                    pstmt.setString(1, member);
                    pstmt.setInt(2, teamID);
                    pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error inserting member: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }

    public void insertNewTeamMember(String string, int team_id) {
        block6: {
            Connection conn = this.establishDatabaseConnection("mineswarm");
            if (conn == null) {
                return;
            }
            PreparedStatement pstmt = null;
            try {
                try {
                    pstmt = conn.prepareStatement("INSERT INTO members(member, team_id) VALUES(?,?)");
                    pstmt.setString(1, string);
                    pstmt.setInt(2, team_id);
                    pstmt.executeUpdate();
                    Database.closePreparedStatementQuietly(pstmt);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().warning(String.format("Error updating new team member in table, error: ", e.getMessage()));
                    Database.closePreparedStatementQuietly(pstmt);
                    Database.closeQuietly(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Database.closePreparedStatementQuietly(pstmt);
                Database.closeQuietly(conn);
                throw throwable;
            }
            Database.closePreparedStatementQuietly(pstmt);
            Database.closeQuietly(conn);
        }
    }
}

